using System;
using System.IO;
using DynaPDF;

namespace table_text
{
   class TableText
   {
      // Error callback function.
      // If the function name should not appear at the beginning of the error message then set
      // the flag emNoFuncNames (pdf.SetErrorMode(DynaPDF.TErrMode.emNoFuncNames);).
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write("{0}\n", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		static void Main(string[] args)
		{
		   try
		   {
            CPDF pdf = new CPDF();
            // Error messages and warnings are passed to the callback function.
            pdf.SetOnErrorProc(IntPtr.Zero, new DynaPDF.TErrorProc(PDFError));
            pdf.CreateNewPDF(null); // We open the output file later if no error occurrs.

            pdf.SetPageCoords(DynaPDF.TPageCoord.pcTopDown);

            int i, rowNum;

            CPDFTable tbl = new CPDFTable(pdf, 3, 3, 500.0f, 100.0f);
            tbl.SetBoxProperty(-1, -1, DynaPDF.TTableBoxProperty.tbpBorderWidth, 1.0f, 1.0f, 1.0f, 1.0f);
            tbl.SetFont(-1, -1, "Arial", DynaPDF.TFStyle.fsRegular, true, DynaPDF.TCodepage.cp1252);
            tbl.SetFont(-1, 1, "Arial", DynaPDF.TFStyle.fsBold, true, DynaPDF.TCodepage.cp1252);
            tbl.SetGridWidth(1.0f, 1.0f);

            String text = "The cell alignment can be set for text, images, and templates...";

            // -1.0 means use the default row height as specified in the CreateTable() call.
            rowNum = tbl.AddRow(-1.0f);
            tbl.SetCellText(rowNum, 0, DynaPDF.TTextAlign.taLeft, DynaPDF.TCellAlign.coTop, text);
            tbl.SetCellText(rowNum, 1, DynaPDF.TTextAlign.taCenter, DynaPDF.TCellAlign.coTop, text);
            tbl.SetCellText(rowNum, 2, DynaPDF.TTextAlign.taRight, DynaPDF.TCellAlign.coTop, text);

            rowNum = tbl.AddRow(-1.0f);
            tbl.SetCellText(rowNum, 0, DynaPDF.TTextAlign.taLeft, DynaPDF.TCellAlign.coCenter, text);
            tbl.SetCellText(rowNum, 1, DynaPDF.TTextAlign.taCenter, DynaPDF.TCellAlign.coCenter, text);
            tbl.SetCellText(rowNum, 2, DynaPDF.TTextAlign.taRight, DynaPDF.TCellAlign.coCenter, text);

            rowNum = tbl.AddRow(-1.0f);
            tbl.SetCellText(rowNum, 0, DynaPDF.TTextAlign.taLeft, DynaPDF.TCellAlign.coBottom, text);
            tbl.SetCellText(rowNum, 1, DynaPDF.TTextAlign.taCenter, DynaPDF.TCellAlign.coBottom, text);
            tbl.SetCellText(rowNum, 2, DynaPDF.TTextAlign.taRight, DynaPDF.TCellAlign.coBottom, text);

            // Draw the table now
            pdf.Append();
            tbl.DrawTable(50.0f, 50.0f, 742.0f);
            while (tbl.HaveMore())
            {
               pdf.EndPage();
               pdf.Append();
               tbl.DrawTable(50.0f, 50.0f, 742.0f);
            }
            pdf.EndPage();


            // Let's change the cell orientation to see what happens...
            tbl.SetCellOrientation(-1, -1, 90);
            pdf.Append();
            pdf.SetFont("Arial", DynaPDF.TFStyle.fsRegular, 12.0, true, DynaPDF.TCodepage.cp1252);
            pdf.WriteText(50.0, 50.0, "The same table but the cell orientation was changed to 90 degrees.");

            tbl.DrawTable(50.0f, 65.0f, 742.0f);
            while (tbl.HaveMore())
            {
               pdf.EndPage();
               pdf.Append();
               tbl.DrawTable(50.0f, 50.0f, 737.0f);
            }
            pdf.EndPage();

            tbl = null;


		      TPDFError err = new TPDFError();
		      for (i = 0; i < pdf.GetErrLogMessageCount(); i++)
		      {
		         pdf.GetErrLogMessage(i, ref err);
		         Console.Write("{0}\n", err.Message);
		      }

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
   }
}
